import React, { memo } from "react";
import { ActivityIndicator, FlatList } from "react-native";
import CustomBottomSheet from "../CustomBottomSheet/CustomBottomSheet";
import SelectSingleItem from "./SelectSingleItem";
import CustomActiveIndicator from "../CustomLoader/CustomActiveIndicator";
import SearchBar from "./SearchBar";
import { useState, useEffect } from "react";

const SelectItemBottomSheet = ({
    snapPoint = [300, 500],
    selectRef,
    data,
    name,
    loading = false,
    isHeaderComponent,
    onPress,
    handleLoadMoreOrders = () => { },
    loadMore,
    isLazyLoad
}) => {
    const [newData, setNewData] = useState(data);
    const [searchText, setSearchText] = useState("");

    useEffect(() => {
        const searchValue = data.filter((item) => {
            const list = item?.name?.toString() || item?.order_key;
            const res = list?.toLowerCase()?.includes(searchText.toLowerCase());
            return res;
        });
        setNewData(searchValue);
    }, [searchText, data]);

    if (loading) {
        <CustomActiveIndicator />;
    }

    const renderFooter = () => {
        if (!loadMore && !isLazyLoad) return null;
        if (isLazyLoad && loadMore) {
            return (
                <ActivityIndicator color='#FCCA19' size='large' />
            );
        }
    }

    const onEndReached = () => {
        if (isLazyLoad) {
            handleLoadMoreOrders();
        }
    };

    return (
        <CustomBottomSheet
            bsRef={selectRef}
            snapPoint={snapPoint}
            isScrollable={true}
            isHeaderComponent={isHeaderComponent}
            handleLoadMoreOrders={isLazyLoad && onEndReached}
            headerComponent={
                <SearchBar
                    name={name}
                    searchText={searchText}
                    setSearchText={setSearchText}
                />
            }
        >
            <FlatList
                data={newData}
                renderItem={({ item, index }) => (
                    <SelectSingleItem
                        selectRef={selectRef}
                        item={item}
                        onPress={onPress}
                        name={name}
                        lastIndex={index === newData.length - 1}
                    />
                )}
                keyExtractor={(_, key) => `bs${key}`}
                ListFooterComponent={renderFooter}
            />
        </CustomBottomSheet>
    );
};

export default memo(SelectItemBottomSheet);
